program mouse;

uses crt, xvga256, xmouse;

const
   MyArrowCursor : TCursor = (
      $FFFF, $FFFF, $FFFF, $FFFF, $FFFF, $FFFF, $FFFF, $FFFF,  { AND mask - rows 1-8 }
      $FFFF, $FFFF, $FFFF, $FFFF, $FFFF, $FFFF, $FFFF, $FFFF,  { AND mask - rows 9-16 }
      $8000, $C000, $8000, $0000, $0000, $0000, $0000, $0000,  { XOR mask - rows 1-8 }
      $0000, $0000, $0000, $0000, $0000, $0000, $0000, $0000   { XOR mask - rows 9-16 }
   );

BEGIN
   clrscr;

   { Check if mouse driver is installed }
   if not (xMouseInit) then
   begin
        writeln('ERROR: Mouse driver not found!');
        writeln('Please load a DOS mouse driver.');
        readln;
        halt;
   end;

   xSetVGAMode;                                       { Set VGA graphics mode }
   {xSetMouseCursor(0,0,MyArrowCursor);}
   xShowMouse;                                        { Show mouse cursor }
   xSetMouseSpeed(50,50);                             { Set mouse speed }
   xSetMouseArea(0,319,0,199);                        { Set mouse movement area on screen }
   xSetMousePosition((320 div 2) * 2, 200 div 2);     { Set initial mouse cursor position }

   while (True) do
   begin
      xMouseUpdate; { Update/check mouse status }

      if(MOUSE_LEFT) then
      begin
         xDrawPixel(ptr(VGA_SEGMENT, 0), MOUSE_X, MOUSE_Y, random(256)); { Draw pixel with random color }
      end;

      if(MOUSE_MIDDLE) then
      begin
         xResetMouse;
      end;

      if(MOUSE_RIGHT) then
      begin
         xHideMouse; { Hide mouse cursor }
         break;
      end;

   end;

   xSetTxtMode; { Switch back to text mode }
   clrscr;
   readln;
END.